import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

import javax.swing.JApplet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


public class main extends  JApplet implements ActionListener, MouseMotionListener, MouseListener, AdjustmentListener, ChangeListener,ItemListener {
	
	  private TextField t;
	  private Scrollbar sb;
	  int i;
	  int drag = -1;
	  int samples = 30;
	  boolean anti = true;

	int dist(int x1,int y1, int x2,int y2){	//vzdialenost 2 bodov
			int d = (int) (Math.sqrt(((x2-x1)*(x2-x1))+((y2-y1)*(y2-y1))));
			return d;
		}
	  
	class point{							//bod
		int x;
		int y;
		int ax;
		int ay;
		point(int xx,int yy){
			x=xx;
			y=yy;
		}
	}
	
	class pointf{							//bod float suradnice
		float x;
		float y;
		float ax;
		float ay;
		pointf(float xx,float yy){
			x=xx;
			y=yy;
		}
	}
	
	class curve{							//samotna krivka
		float alfa=(float)0.0;					//nase t
		point pt;							//bod pre t = nase t
		Vector<point> control_points = new Vector<point>();	//vektor kontrolnych bodov
		
		point hermit(float t,Graphics g,point p1,point p2){	//pocita pre urcite t bod ktory dostaneme decasteljauovym algoritmom
			point ps = new point(0,0);
			
			double xx=(((2*p1.x)+(-2*p2.x)+p1.ax+p2.ax)*(t*t*t))+(((-3*p1.x)+(3*p2.x)+(-2*p1.ax)+(-p2.ax))*(t*t))+(p1.ax*t)+(p1.x);
			double yy=(((2*p1.y)+(-2*p2.y)+p1.ay+p2.ay)*(t*t*t))+(((-3*p1.y)+(3*p2.y)+(-2*p1.ay)+(-p2.ay))*(t*t))+(p1.ay*t)+(p1.y);

			ps.x=(int) xx;
			ps.y=(int) yy;
		
			return ps;
		}
		
		void sipka(Graphics g,int x0,int y0,int x1,int y1){
			g.drawLine(x0, y0, x1, y1);
			int deltaX = x1 - x0;
			int deltaY = y1 - y0;
			double size = Math.sqrt((deltaX*deltaX)+(deltaY*deltaY));
			double frac = (double)6/(double)size;
	
			g.drawLine(x0 + (int)((1-frac)*deltaX + frac*deltaY),
				   y0 + (int)((1-frac)*deltaY - frac*deltaX),
				   x1, y1);
			g.drawLine(x0 + (int)((1-frac)*deltaX - frac*deltaY),
				   y0 + (int)((1-frac)*deltaY + frac*deltaX),
				   x1, y1);
		}
		
		void setderivate(Graphics g){
			for(int i=1;i<control_points.size()-1;i++){
				float dx = ((float)(1-alfa)/(float)2)*(control_points.elementAt(i+1).x-control_points.elementAt(i-1).x);
				float dy = ((float)(1-alfa)/(float)2)*(control_points.elementAt(i+1).y-control_points.elementAt(i-1).y);
				control_points.elementAt(i).ax= (int) dx;
				control_points.elementAt(i).ay= (int) dy;
				g.setColor(Color.green);
				sipka(g,control_points.elementAt(i).x,control_points.elementAt(i).y,control_points.elementAt(i).x+control_points.elementAt(i).ax,control_points.elementAt(i).y+control_points.elementAt(i).ay);
			}
		}
		
		
		void kreslicurve(Graphics g,Color c){		//vykresli krivku
			g.setColor(c);
			point point1 = null;
			point point2 = null;
			
			for(int i=1;i<control_points.size()-2;i++){
				float f=0;
				while(f<=1){
					point1=hermit(f,g,control_points.elementAt(i),control_points.elementAt(i+1));
					f=(float) (f+ (float) 1 / (float) (control_points.size()*samples));
					if(point2 != null)g.drawLine(point1.x, point1.y, point2.x, point2.y);
					point2=hermit(f,g,control_points.elementAt(i),control_points.elementAt(i+1));
					f=(float) (f+ (float) 1 / (float) (control_points.size()*samples));
					g.drawLine(point1.x, point1.y, point2.x, point2.y);
				}
			}
		}
		
		int checkcurve(int xx,int yy){		//zisti ci sme klikli vedla niektoreho kontorlneho bodu
			for(int i=0;i<control_points.size();i++){
				if(dist(xx,yy,control_points.elementAt(i).x,control_points.elementAt(i).y) < 10){
					return i;
				}
			}
			return -1;
		}
		
		void drawpoints(Graphics g){		//kresli kontrolne body
		    Graphics2D g2d = (Graphics2D)g;
		    g2d.setStroke(new BasicStroke(2));
			for(int i=0;i<control_points.size();i++){
				g.setColor(Color.red);
				g.fillOval(control_points.elementAt(i).x-5, control_points.elementAt(i).y-5, 10, 10);
			}
		    g2d.setStroke(new BasicStroke(2,BasicStroke.CAP_BUTT,BasicStroke.JOIN_BEVEL,0,new float[] {9},0));
			if(control_points.size()>2){
				g.setColor(Color.lightGray);
				g.drawLine(control_points.firstElement().x, control_points.firstElement().y, control_points.elementAt(1).x, control_points.elementAt(1).y);
				g.drawLine(control_points.lastElement().x, control_points.lastElement().y, control_points.elementAt(control_points.size()-2).x, control_points.elementAt(control_points.size()-2).y);
			}
		    g2d.setStroke(new BasicStroke(2));
			setderivate(g);
		}
	}
	
	curve cv = new curve();
	
	private static final long serialVersionUID = -3408028698279739454L;
	
	@SuppressWarnings("deprecation")
	public void init(){					//inicializacia
		super.setName("Bezier 1,2");
		this.setLayout(null);
		resize(800,600);
	    sb = new  Scrollbar(Scrollbar.HORIZONTAL, 1000, 50, 0, 2050);
	    sb.addAdjustmentListener(this);
	    this.add(sb);
	    sb.setBounds(100,10,650,20);
	    this.t = new TextField(6);
	    addMouseListener(this);
	    addMouseMotionListener(this);
	    t.setBounds(10, 10, 80, 20);
	    t.disable();
	    this.add(t);
	    setVisible(true);
	}
	
	  public void start()
	  {
	  }

	  public void paint(Graphics g) {
		  Image buf=createImage(getSize().width,getSize().height);
		  Graphics bufG=buf.getGraphics();
		  paintit(bufG);
		  g.drawImage(buf,0,0,null);
		  bufG.dispose();
		}
	  
	public void paintit(Graphics g){		//kreslenie do plochy, hlavna procedura
		   Graphics2D g2 = (Graphics2D)g;
		   if(anti)g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
		                        RenderingHints.VALUE_ANTIALIAS_ON);
		g.drawRect(0, 0, 799, 599);
		g.drawString("-10", 100, 45);
		g.drawString("10", 730, 45);
		g.drawString("0", 422, 45);
		g.setColor(Color.green);
		cv.drawpoints(g);
		cv.kreslicurve(g, Color.blue);
	}
	
    public void update(Graphics g){
        paint(g);
    }

	public void adjustmentValueChanged(AdjustmentEvent arg0) {	//pohnutie scrollbarom
	    cv.alfa=(float) ((float) -10+(10*(sb.getValue()*0.001)));
	    this.t.setText("alfa: " + String.valueOf(cv.alfa));
	    repaint();
	}

	public void mouseClicked(MouseEvent e) {	
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {	
	}

	public void mousePressed(MouseEvent e) {		//stlacenie mysky
		int v = cv.checkcurve(e.getX(), e.getY());
		if(v==-1){
		cv.control_points.add(new point(e.getX(),e.getY()));
		}else{
			drag=v;
		}
		repaint();
		
	}

	public void mouseReleased(MouseEvent e) {		//pustenie mysky
		if(drag != -1)drag=-1;
		repaint();
	}

	public void mouseDragged(MouseEvent e) {		//tahanie mysky
		if(drag != -1){
			cv.control_points.elementAt(drag).x=e.getX();
			cv.control_points.elementAt(drag).y=e.getY();
		}
		repaint();
	}

	public void mouseMoved(MouseEvent e) {
	}

	public void actionPerformed(ActionEvent e) {
	}

	public void stateChanged(ChangeEvent e) {
		// TODO Auto-generated method stub
		
	}

	@SuppressWarnings("deprecation")
	public void itemStateChanged(ItemEvent e) {
		
	}
}

//2008 Lukas Tencer 