import java.awt.BasicStroke;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Label;
import java.awt.RenderingHints;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

import javax.swing.JApplet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


public class main extends  JApplet implements ActionListener, MouseMotionListener, MouseListener, AdjustmentListener, ChangeListener,ItemListener {
	
	  private Checkbox ch2;
	  int i;
	  int drag = -1;
	  int samples = 30;
	  boolean animate = false;
	  boolean anti = true;
	  mybar bar1;

	int dist(int x1,int y1, int x2,int y2){	//vzdialenost 2 bodov
			int d = (int) (Math.sqrt(((x2-x1)*(x2-x1))+((y2-y1)*(y2-y1))));
			return d;
		}
	
	class mybar{
		int x=0,y=0;
		int high=10,width=100;
		Vector<mypin> pins = new Vector<mypin>();
		int activ = -1;
		float max = 1;
		float min = 0;
		
		class mypin{
			float t;
			mypin(){
				//t=tt;
			}
		}
		
		void addpin(int n){
			pins.add(new mypin());
			for(int i=0;i<pins.size();i++){
				pins.elementAt(i).t=(float)(i+1)/(float)(n-1);
				pins.elementAt(i).t *= 100;
				pins.elementAt(i).t = (float)Math.round(pins.elementAt(i).t)/100;
				cv.control_points.elementAt(i+1).t=pins.elementAt(i).t;
			}
			cv.control_points.lastElement().t=1;
		}
		
		void draw(Graphics g){
			g.setColor(Color.black);
			g.fillRect(x, y+(high/2)-2, width, 4);
			g.fillRect(x, y, 3, high);
			g.fillRect(x+width-3, y, 3, high);
			for(int i=0;i< pins.size();i++){
				int mx = x+((int)(width*pins.elementAt(i).t))-high/2;
				int my = y;
				g.setColor(Color.black);
				g.drawOval(mx, my, high, high);
				g.setColor(Color.white);
				g.fillOval(mx, my, high, high);
				if(i==activ){
					g.setColor(Color.red);
				}else{
					g.setColor(Color.gray);
				}
				g.fillOval(mx+high/3, my+high/3, high/2, high/2);
				g.setColor(Color.black);
				g.drawString("V"+i+" : t="+pins.elementAt(i).t, mx-(high/2), y+high*2);
			}
		}
		
		boolean selectpin(int xx,int yy){
			for(int i=0;i< pins.size();i++){
				if(dist(xx,yy,x+((int)(width*pins.elementAt(i).t)),y+(high/2))<(high)/2){
					activ=i;
				}
			}
			
			if(activ!=-1){
			float actt = pins.elementAt(activ).t;
				for(int i=0;i< pins.size();i++){
						if((pins.elementAt(i).t<actt)&&(pins.elementAt(i).t>min)){
							min=pins.elementAt(i).t;
						}
						if((pins.elementAt(i).t>actt)&&(pins.elementAt(i).t<max)){
							max=pins.elementAt(i).t;
						}
				}
			}
			
			if (activ!=-1)return true;
			return false;
		}
		
		boolean dragpin(int xx, int yy){
			float t1 = (float)(xx-x)/(float)width;
			t1 *= 100;
			t1 = (float)Math.round(t1)/100;
			if((t1>min)&&(t1<max)){
				pins.elementAt(activ).t=t1;
				cv.control_points.elementAt(activ+1).t=t1;
			}
			return false;
		}		
		
		mybar(int xx,int yy,int h,int w){
			x=xx;
			y=yy;
			high=h;
			width=w;
		}
		
	}
	  
	class point{							//bod
		int x;
		int y;
		float t;
		point(int xx,int yy){
			x=xx;
			y=yy;
		}
	}
	
	class pointf{							//bod float suradnice
		float x;
		float y;
		float f;
		pointf(float xx,float yy, float tt){
			f=tt;
			x=xx;
			y=yy;
		}
	}
	
	class curve{							//samotna krivka
		float t=(float)0.5;					//nase t
		point pt;							//bod pre t = nase t
		Vector<point> control_points = new Vector<point>();	//vektor kontrolnych bodov
		
		point lagrange(float t,Graphics g){	//pocita pre urcite t bod ktory dostaneme aitkenovym algoritmom
			point p1;
			Vector<pointf> work = new Vector<pointf>();
			
			for(int i=0;i<control_points.size();i++){
				work.add(new pointf(control_points.elementAt(i).x,control_points.elementAt(i).y,control_points.elementAt(i).t));
			}
			
			while(work.size()>1){
				int r=cv.control_points.size()-work.size()+1;
				for(int i=0;i<work.size()-1;i++){
				work.elementAt(i).x=(((float)(control_points.elementAt(i+r).t-t)/(float)(control_points.elementAt(i+r).t-control_points.elementAt(i).t))*work.elementAt(i).x)  +  (((float)(t-control_points.elementAt(i).t)/(float)(control_points.elementAt(i+r).t-control_points.elementAt(i).t))*work.elementAt(i+1).x);
				work.elementAt(i).y=(((float)(control_points.elementAt(i+r).t-t)/(float)(control_points.elementAt(i+r).t-control_points.elementAt(i).t))*work.elementAt(i).y)  +  (((float)(t-control_points.elementAt(i).t)/(float)(control_points.elementAt(i+r).t-control_points.elementAt(i).t))*work.elementAt(i+1).y);
				}
				work.setSize(work.size()-1);
			}
			p1=new point((int)work.firstElement().x,(int)work.firstElement().y);
			work.clear();	
			return p1;
		}
		
		void kreslicurve(Graphics g,Color c){		//vykresli krivku pre t=0..1 na jeden bod krizvky *samples vzokiek
			point point1=new point(0,0);
			point point2=new point(0,0);
			point2.x=control_points.firstElement().x;
			point2.y=control_points.firstElement().y;
			float i=0;
			g.setColor(c);
			while(i<1){
				i=(float) (i+ (float) 1 / (float) (control_points.size()*samples));
				point1=lagrange(i,g);
				if(i<1)
				g.drawLine(point1.x, point1.y, point2.x, point2.y);
				i=(float) (i+ (float) 1 / (float) (control_points.size()*samples));
				if(i<1)
				point2=lagrange(i,g);
				if(i<1)
				g.drawLine(point1.x, point1.y, point2.x, point2.y);
			}
			g.drawLine(point2.x, point2.y, control_points.lastElement().x, control_points.lastElement().y);
		}
		
		int checkcurve(int xx,int yy){		//zisti ci sme klikli vedla niektoreho kontorlneho bodu
			for(int i=0;i<control_points.size();i++){
				if(dist(xx,yy,control_points.elementAt(i).x,control_points.elementAt(i).y) < 10){
					return i;
				}
			}
			return -1;
		}
		
		void drawpoints(Graphics g){		//kresli kontrolne body
		    Graphics2D g2d = (Graphics2D)g;
		    g2d.setStroke(new BasicStroke(2));
			for(int i=0;i<control_points.size();i++){
				g.setColor(Color.red);
				g.fillOval(control_points.elementAt(i).x-5, control_points.elementAt(i).y-5, 10, 10);
				g.setColor(Color.magenta);
				g.drawString("t:"+control_points.elementAt(i).t, control_points.elementAt(i).x, control_points.elementAt(i).y-5);
				g.drawString("V"+i, control_points.elementAt(i).x, control_points.elementAt(i).y-17);
				if(i!=0){
					g.setColor(Color.green);
					g.drawLine(control_points.elementAt(i).x, control_points.elementAt(i).y,control_points.elementAt(i-1).x, control_points.elementAt(i-1).y);
				}
			}
		}
	}
	
	curve cv = new curve();
	
	private static final long serialVersionUID = -3408028698279739454L;
	
	public void init(){					//inicializacia
		super.setName("Bezier 1,2");
		this.setLayout(null);
		resize(800,600);
	    addMouseListener(this);
	    addMouseMotionListener(this);
	    ch2 = new Checkbox("antialias");
	    ch2.setBounds(715,35, 70, 20);
	    ch2.setState(true);
	    this.add(ch2);
	    ch2.addItemListener(this);
	    setVisible(true);
	    bar1=new mybar(20,10,20,700);
	    repaint();
	}
	
	  public void start()
	  {
	  }

	  public void paint(Graphics g) {
		  Image buf=createImage(getSize().width,getSize().height);
		  Graphics bufG=buf.getGraphics();
		  paintit(bufG);
		  g.drawImage(buf,0,0,null);
		  bufG.dispose();
		}
	  
	public void paintit(Graphics g){		//kreslenie do plochy, hlavna procedura
		   Graphics2D g2 = (Graphics2D)g;
		   if(anti)g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
		                        RenderingHints.VALUE_ANTIALIAS_ON);
		g.drawRect(0, 0, 799, 599);
		g.setColor(Color.green);
		if(bar1!=null)bar1.draw(g);
		cv.drawpoints(g);
		if(cv.control_points.size()>0){
			cv.kreslicurve(g,Color.blue);
		}
	}
	
    public void update(Graphics g){
        paint(g);
    }

	public void adjustmentValueChanged(AdjustmentEvent arg0) {	//pohnutie scrollbarom
	    repaint();
	}

	public void mouseClicked(MouseEvent e) {	
	}

	public void mouseEntered(MouseEvent e) {
	}

	public void mouseExited(MouseEvent e) {	
	}

	public void mousePressed(MouseEvent e) {		//stlacenie mysky
		if(bar1.selectpin(e.getX(), e.getY())==false){
			int v = cv.checkcurve(e.getX(), e.getY());
			if(v==-1){
			cv.control_points.add(new point(e.getX(),e.getY()));
			if(cv.control_points.size()>2){
				bar1.addpin(cv.control_points.size());
				}else{
					if(cv.control_points.size() == 1){
						cv.control_points.lastElement().t=0;
					}
					if(cv.control_points.size() == 2){
						cv.control_points.lastElement().t=1;
					}
				}
			}else{
				drag=v;
			}
		}
		repaint();
	}

	public void mouseReleased(MouseEvent e) {		//pustenie mysky
		if(bar1.activ==-1){
		if(drag != -1)drag=-1;
			cv.pt=cv.lagrange(cv.t,null);
		}else{
			bar1.activ=-1;
			bar1.min=0;
			bar1.max=1;
		}
		repaint();
	}

	public void mouseDragged(MouseEvent e) {		//tahanie mysky
		if(bar1.activ==-1){
			if(drag != -1){
				cv.control_points.elementAt(drag).x=e.getX();
				cv.control_points.elementAt(drag).y=e.getY();
			}
		}else{
			bar1.dragpin(e.getX(), e.getY());
		}
		repaint();
	}

	public void mouseMoved(MouseEvent e) {
	}

	public void actionPerformed(ActionEvent e) {
	}

	public void stateChanged(ChangeEvent e) {
		// TODO Auto-generated method stub
		
	}

	@SuppressWarnings("deprecation")
	public void itemStateChanged(ItemEvent e) {
		if(e.getSource()==ch2){
			anti=!anti;
		}
		repaint();
	}
}

//2008 Lukas Tencer 